@extends('frontend.include.app')
<style>
    .error{
        color: red !important;;
    }
</style>
<div class="inner-login vendor">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="{{ asset('frontend/images/login.png') }}" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                            </div>
                            <h2>Reset Password</h2>

                        <form method="POST" action="{{ route('reset.password') }}" class="email-login" id="login-form">
                            @csrf
                            <div class="row">
                                <div class="col-md-12 inner-main-input mb-3">
                                    <input type="hidden" name="token" value="{{$usertoken}}">
                                    <label for="password" class="form-label">New Password</label>
                                    <input id="password" type="password" class="form-control" name="password" placeholder="Enter New Password" required>
                                </div>
                                <div class="col-md-12 inner-main-input mb-3">
                                    <label for="confirm_password" class="form-label">Confirm New Password</label>
                                    <input id="confirm_password" type="password" class="form-control" name="confirm_password" placeholder="Enter Confirm New Password" required>
                                </div>
                            </div>
                            <button type="submit" class="btn primary-btn w-100">
                                Reset Password
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery and Validation Plugin -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<script>
    $(document).ready(function() {
        // Add custom password rule
        $.validator.addMethod("strongPassword", function(value, element) {
            return this.optional(element) || /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*#?&])[\S]{8,}$/.test(value);
        }, "New password must be at least 8 characters long with uppercase, lowercase, number, special character, and no spaces.");
    
        $("#login-form").validate({
            rules: {
                password: {
                    required: true,
                    strongPassword: true
                },
                confirm_password: {
                    required: true,
                    equalTo: "#password"
                }
            },
            messages: {
                password: {
                    required: "Please enter new password.",
                    strongPassword: "New password must be at least 8 characters long with uppercase, lowercase, number, special character, and no spaces."
                },
                confirm_password: {
                    required: "Please enter confirm new password.",
                    equalTo: "New password and confirm new password does not match."
                }
            },
            errorElement: "div",
            errorClass: "error"
        });
    });
    </script>